<?php
session_start();

require 'config.php'; // Include the PDO configuration file
include 'header.php';

// Ensure the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch user data
$user_id = $_SESSION['user_id'];
try {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        throw new Exception("User not found.");
    }
    
    // Fetch user info statistics
    $stmt_info = $pdo->prepare("SELECT * FROM userinfo WHERE mt5username = ?");
    $stmt_info->execute([$user['mt5username']]);
    $stats = $stmt_info->fetch(PDO::FETCH_ASSOC);

    if (!$stats) {
        throw new Exception("User info statistics not found.");
    }

    // Handle form submission for profile update
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $username = $_POST['username'];
        $email = $_POST['email'];
        $contact_number = $_POST['contact_number'];
        $full_name = $_POST['full_name'];
        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];

        if ($password !== $confirm_password) {
            $error = "Passwords do not match.";
        } else {
            $password_hash = password_hash($password, PASSWORD_DEFAULT);

            $stmt_update = $pdo->prepare("UPDATE users SET username = ?, email = ?, contact_number = ?, full_name = ?, password = ? WHERE id = ?");
            $stmt_update->execute([$username, $email, $contact_number, $full_name, $password_hash, $user_id]);

            if ($stmt_update->rowCount()) {
                $success = "Profile updated successfully.";
            } else {
                $error = "Error updating profile.";
            }
        }
    }

    // Calculate adjusted profit
    $percentage = $user['percentage']; // Fetch the percentage column value
    $profit = $stats['profit'];
    $adjusted_profit = $profit - ($profit * ($percentage / 100)); // Calculate adjusted profit

    // Calculate adjusted balance
    $balance = $stats['balance'];
    $adjusted_balance = $balance - ($balance * ($percentage / 100)); // Calculate adjusted balance

    // Parse and clean the open trades data
    $open_trades_raw = $stats['open_trades'];
    $trades = explode(';', trim($open_trades_raw, ';'));

    $formatted_trades = [];
    foreach ($trades as $trade) {
        $details = [];
        // Regex to match specific fields
        if (preg_match_all('/(?:Symbol|Profit|Type):\s*([^,;]+)(?:[,;]|\s*)/', $trade, $matches, PREG_SET_ORDER)) {
            foreach ($matches as $match) {
                // Process fields
                if ($match[0] === 'Profit:') {
                    // Format profit with £ symbol and adjust based on percentage
                    $profit_amount = $match[1];
                    // Adjust profit with percentage
                    $profit_amount_adjusted = number_format($profit_amount * (1 - ($percentage / 100)), 2);
                    $details[] = '£' . $profit_amount_adjusted;
                } else {
                    $details[] = $match[1];
                }
            }
        }
        // Remove any empty values and ensure proper formatting
        $formatted_trades[] = implode(', ', array_filter($details));
    }
    // Join trades with HTML line breaks
    $open_trades_formatted = implode('<br>', $formatted_trades);

} catch (Exception $e) {
    $error = $e->getMessage();
}
?>
<style>
.container {
    margin-top: 100px;
}

/* Add your styles here */
</style>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings</title>
    <link rel="stylesheet" href="styles.css"> <!-- Link to your stylesheet -->
</head>
<body>
    <div class="container">
        <h2>Account Statistics</h2>
        <table>
            <tr><th>Balance: </th><td>£<?php echo number_format($adjusted_balance, 2); ?></td></tr>
            <tr><th>Open Profit: </th><td>£<?php echo number_format($adjusted_profit, 2); ?></td></tr> <!-- Display adjusted profit -->
            <tr><th>Open Trades: </th> <td><?php echo $open_trades_formatted; ?></td></tr>
        </table>

        <br>
        <h2>Account Settings</h2>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <form method="post" action="">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($user['id']); ?>" readonly>
            <input type="text" name="username" value="<?php echo htmlspecialchars($user['username']); ?>" required>
            <input type="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
            <input type="tel" name="contact_number" value="<?php echo htmlspecialchars($user['contact_number']); ?>" required>
            <input type="text" name="full_name" value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
            <input type="text" name="mt5username" value="<?php echo htmlspecialchars($user['mt5username']); ?>" readonly>
            <input type="hidden" name="status" value="<?php echo htmlspecialchars($user['status']); ?>" readonly>
            <input type="hidden" name="investment" value="<?php echo htmlspecialchars($user['investment']); ?>" readonly>
            <input type="password" name="password" placeholder="New Password" required>
            <input type="password" name="confirm_password" placeholder="Confirm New Password" required>
            <center><button type="submit">Save Changes</button></center>
        </form>
    </div>
</body>
</html>
